import org.uddi4j.client.UDDIProxy;
import org.uddi4j.response.AuthToken;
import org.uddi4j.response.DispositionReport;
import org.uddi4j.response.TModelInfo;
import org.uddi4j.response.TModelInfos;
import org.uddi4j.response.TModelList;
import org.uddi4j.transport.TransportFactory;
import java.security.Security;
import java.util.Vector;

public class UDDIDeleteTModel1 {

	public static void main(String[] args) throws Exception {

		System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");      
		Security.addProvider(new com.sun.net.ssl.internal.ssl.Provider());

		System.setProperty(TransportFactory.PROPERTY_NAME, "org.uddi4j.transport.ApacheAxisTransport");

		UDDIProxy proxy = new UDDIProxy();
		proxy.setInquiryURL("http://uddi.microsoft.com/inquire");
		proxy.setPublishURL("https://uddi.microsoft.com/publish");

		TModelList tl = proxy.find_tModel("servicesweb-compagnie-com:inquiry", null, null, null, 0);

		TModelInfos tis = tl.getTModelInfos();
		if (tis.size() == 0) {
			System.out.println("no tmodel(s) found");
			System.exit(0);
		}

		AuthToken at = proxy.get_authToken("user", "password");

		System.out.println(tis.size()+" tmodel(s) found\n");
		Vector tiv = tis.getTModelInfoVector();
		for (int i = 0; i < tiv.size(); i++) {
			TModelInfo ti = (TModelInfo)tiv.elementAt(i);
			System.out.println(ti.getNameString());
			System.out.println(ti.getTModelKey());
			DispositionReport dr = proxy.delete_tModel(at.getAuthInfoString(), ti.getTModelKey());
			System.out.println("tmodel deleted : "+dr.success());
			System.out.println("\n");
		}
		proxy.discard_authToken(at.getAuthInfo());
	}
}